% This procedure creates table 22
% It uses the estimation results produced in GMM_main
clear

load ../../'Estimation Results'/Benchmark_Model.mat model_moments

benchm_moments = model_moments;

load ../../'Estimation Results'/Model_w_inv_shocks

disp(' ')
disp('Table 22: Data and model moments: investment cost shocks')
disp(' ')
disp( 'Moment        :  Data   (std)|   Cost Shocks  |  Benchm. Model')
disp(['Var(p)        :  ' num2str(moments(1), '%.2f') ' (' num2str(std_moments(1), '%.2f') ') |     ' num2str(model_moments(1), '%.2f') '       |       ' num2str(benchm_moments(1), '%.2f')])
disp(['Var(I_n)      :  ' num2str(moments(2), '%.2f') ' (' num2str(std_moments(2), '%.2f') ') |     ' num2str(model_moments(2), '%.2f') '       |       ' num2str(benchm_moments(2), '%.2f')])
disp(['Var(I_o)      :  ' num2str(moments(3), '%.2f') ' (' num2str(std_moments(3), '%.2f') ') |     ' num2str(model_moments(3), '%.2f') '       |       ' num2str(benchm_moments(3), '%.2f')])
disp(['Var(q_n)      :  ' num2str(moments(4), '%.2f') ' (' num2str(std_moments(4), '%.3f') ')|     ' num2str(model_moments(4), '%.2f') '       |       ' num2str(benchm_moments(4), '%.2f')])
disp(['Var(q_o)      :  ' num2str(moments(5), '%.2f') ' (' num2str(std_moments(5), '%.2f') ') |     ' num2str(model_moments(5), '%.2f') '       |       ' num2str(benchm_moments(5), '%.2f')])
disp(['Corr(p, I_n)  :  ' num2str(moments(6), '%.2f') ' (' num2str(std_moments(6), '%.2f') ') |     ' num2str(model_moments(6), '%.2f') '       |       ' num2str(benchm_moments(6), '%.2f')])
disp(['Corr(p, I_o)  :  ' num2str(moments(7), '%.2f') ' (' num2str(std_moments(7), '%.2f') ') |     ' num2str(model_moments(7), '%.2f') '       |       ' num2str(benchm_moments(7), '%.2f')])
disp(['Corr(p, q_n)  :  ' num2str(moments(8), '%.2f') ' (' num2str(std_moments(8), '%.2f') ')|    ' num2str(model_moments(8), '%.2f') '       |       ' num2str(benchm_moments(8), '%.2f')])
disp(['Corr(p, q_o)  :  ' num2str(moments(9), '%.2f') ' (' num2str(std_moments(9), '%.2f') ') |    ' num2str(model_moments(9), '%.2f') '       |      ' num2str(benchm_moments(9), '%.2f')])
disp(['Corr(I_n, I_o):  ' num2str(moments(10), '%.2f') ' (' num2str(std_moments(10), '%.2f') ') |     ' num2str(model_moments(10), '%.2f') '       |       ' num2str(benchm_moments(10), '%.2f')])
disp(['Corr(I_n, q_n):  ' num2str(moments(11), '%.2f') ' (' num2str(std_moments(11), '%.2f') ') |     ' num2str(model_moments(11), '%.2f') '       |       ' num2str(benchm_moments(11), '%.2f')])
disp(['Corr(I_n, q_o):  ' num2str(moments(12), '%.2f') ' (' num2str(std_moments(12), '%.2f') ') |     ' num2str(model_moments(12), '%.2f') '       |       ' num2str(benchm_moments(12), '%.2f')])
disp(['Corr(I_o, q_n): ' num2str(moments(13), '%.2f') ' (' num2str(std_moments(13), '%.2f') ') |     ' num2str(model_moments(13), '%.2f') '       |       ' num2str(benchm_moments(13), '%.2f')])
disp(['Corr(I_o, q_o): ' num2str(moments(14), '%.2f') ' (' num2str(std_moments(14), '%.2f') ') |     ' num2str(model_moments(14), '%.2f') '       |       ' num2str(benchm_moments(14), '%.2f')])
disp(['Corr(q_n, q_o): ' num2str(moments(15), '%.2f') ' (' num2str(std_moments(15), '%.2f') ') |     ' num2str(model_moments(15), '%.2f') '       |       ' num2str(benchm_moments(15), '%.2f')])
for i = 1:N_ll
    disp(['Auto_corr(p)  : ' num2str(moments(15+5*(i-1)+1), '%.2f') ' (' num2str(std_moments(15+5*(i-1)+1), '%.2f') ') |    ' num2str(model_moments(15+5*(i-1)+1), '%.2f') '       |      ' num2str(benchm_moments(15+5*(i-1)+1), '%.2f')])
    disp(['Auto_corr(I_n):  ' num2str(moments(15+5*(i-1)+2), '%.2f') ' (' num2str(std_moments(15+5*(i-1)+2), '%.2f') ') |     ' num2str(model_moments(15+5*(i-1)+2), '%.2f') '       |       ' num2str(benchm_moments(15+5*(i-1)+2), '%.2f')])
    disp(['Auto_corr(I_o):  ' num2str(moments(15+5*(i-1)+3), '%.2f') ' (' num2str(std_moments(15+5*(i-1)+3), '%.2f') ') |     ' num2str(model_moments(15+5*(i-1)+3), '%.2f') '       |       ' num2str(benchm_moments(15+5*(i-1)+3), '%.2f')])
    disp(['Auto_corr(q_n):  ' num2str(moments(15+5*(i-1)+4), '%.2f') ' (' num2str(std_moments(15+5*(i-1)+4), '%.2f') ') |     ' num2str(model_moments(15+5*(i-1)+4), '%.2f') '       |       ' num2str(benchm_moments(15+5*(i-1)+4), '%.2f')])
    disp(['Auto_corr(q_o):  ' num2str(moments(15+5*(i-1)+5), '%.2f') ' (' num2str(std_moments(15+5*(i-1)+5), '%.2f') ') |     ' num2str(model_moments(15+5*(i-1)+5), '%.2f') '       |      ' num2str(benchm_moments(15+5*(i-1)+5), '%.2f')])
end
